/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.client;

import oracle.cluster.verification.fixup.FixupUtility;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.security.NullSecurityManager;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ClusterVerifier;
import oracle.ops.verification.framework.engine.component.ComponentInitException;
import oracle.ops.verification.framework.engine.component.InvalidComponentException;
import oracle.ops.verification.framework.engine.stage.InvalidStageException;
import oracle.ops.verification.framework.engine.stage.StageInitException;
import oracle.ops.verification.framework.param.InvalidCommandlineException;
import oracle.ops.verification.framework.param.ParamManager;
import oracle.ops.verification.framework.param.UninitializedParamManagerException;
import oracle.ops.verification.framework.util.InvalidEnvironmentException;
import oracle.ops.verification.framework.util.VerificationLogData;
import oracle.ops.verification.framework.util.VerificationUtil;

public class CluvfyDriver {
    private static String CV = "cv";
    private static String LOG = "log";
    static final String LSEP = System.getProperty("line.separator");
    private static MessageBundle s_gMsgBundle = VerificationUtil.getMessageBundle("Prvg");
    private static MessageBundle s_msgBundle = VerificationUtil.getMessageBundle("Prvf");

    public CluvfyDriver() {
        if (System.getSecurityManager() == null) {
            System.setSecurityManager((SecurityManager)new NullSecurityManager());
            Trace.out((String)"Security manager is set");
        }
    }

    public void parseArguments(String[] args) throws InvalidCommandlineException {
        ParamManager pm = ParamManager.getInstance(ParamManager.OperationMode.MODE_CLI, args);
        Trace.out((String)("ParamManager contains:\r\n" + pm));
    }

    public static void main(String[] args) {
        VerificationUtil.setupTracing(true);
        CluvfyDriver cluvfyDriver = new CluvfyDriver();
        if (!VerificationUtil.checkPlatform()) {
            String suppos = VerificationUtil.getSupportedOS();
            String supparch = VerificationUtil.getSupportedArch();
            System.out.println(s_msgBundle.getMessage("9407", true, (Object[])new String[]{suppos, supparch}));
            Trace.out((String)("Invalid platform. This distribution is valid only for OS " + suppos + " running on hardware architecture " + supparch));
            VerificationLogData.traceLogData();
            System.exit(1);
        }
        try {
            cluvfyDriver.parseArguments(args);
        }
        catch (InvalidCommandlineException e) {
            Trace.out((String)e.getMessage());
            Trace.stackTrace((Throwable)e);
            System.out.println(e.getMessage());
            VerificationLogData.traceLogData();
            System.exit(1);
        }
        ClusterVerifier clusterVfy = null;
        try {
            clusterVfy = new ClusterVerifier();
        }
        catch (InvalidEnvironmentException iee) {
            Trace.out((String)iee.getMessage());
            VerificationLogData.traceLogData();
            System.exit(1);
        }
        ParamManager pm = null;
        int exitStatusVal = 0;
        try {
            pm = ParamManager.getInstance();
        }
        catch (UninitializedParamManagerException upme) {
            Trace.out((String)upme.getMessage());
            System.out.println(upme.getMessage());
            VerificationLogData.traceLogData();
            System.exit(1);
        }
        if (pm.checkArgFixup() || pm.checkArgFixupNoExecute()) {
            FixupUtility.setDefaultFixupRequirement(true);
        }
        if (pm.checkArgComp()) {
            boolean compChkSuccessful = false;
            try {
                compChkSuccessful = clusterVfy.verifyComponent(pm.getCompID());
            }
            catch (InvalidComponentException ice) {
                Trace.out((String)("INVALIDECOMPONENTEXCEPTION: " + ice.getMessage()));
                Trace.stackTrace((Throwable)((Object)ice));
                System.out.println(ice.getMessage());
                System.out.println(LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
                VerificationLogData.traceLogData();
                System.exit(1);
            }
            catch (ComponentInitException e) {
                Trace.out((String)("COMPONENTINITEXCEPTION: " + e.getMessage()));
                Trace.stackTrace((Throwable)((Object)e));
                System.out.println(e.getMessage());
                System.out.println(LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
                VerificationLogData.traceLogData();
                System.exit(1);
            }
            catch (RuntimeException e) {
                Trace.out((String)("RUNTIMEEXCEPTION: " + e.getMessage()));
                Trace.stackTrace((Throwable)e);
                VerificationLogData.logError("RUNTIMEEXCEPTION: " + e.getMessage() + "\n" + Trace.getStackTrace((Throwable)e));
                System.out.println(LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
                VerificationLogData.traceLogData();
                System.exit(1);
            }
            exitStatusVal = compChkSuccessful ? 0 : 1;
        } else if (pm.checkArgStage()) {
            boolean stageChkSuccessful = false;
            try {
                int mode;
                int n = mode = pm.checkArgPre() ? 1 : 2;
                stageChkSuccessful = pm.checkArgFixup() ? clusterVfy.verifyStage(pm.getStageID(), mode) : clusterVfy.verifyStage(pm.getStageID(), mode);
            }
            catch (InvalidStageException ise) {
                Trace.out((String)("INVALIDSTAGEEXCEPTION: " + ise.getMessage()));
                Trace.stackTrace((Throwable)((Object)ise));
                System.out.println(ise.getMessage());
                System.out.println(LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
                VerificationLogData.traceLogData();
                System.exit(1);
            }
            catch (StageInitException e) {
                Trace.out((String)("STAGEINITEXCEPTION: " + e.getMessage()));
                Trace.stackTrace((Throwable)((Object)e));
                System.out.println(e.getMessage());
                System.out.println(LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
                VerificationLogData.traceLogData();
                System.exit(1);
            }
            exitStatusVal = stageChkSuccessful ? 0 : 1;
        } else {
            Trace.out((String)"ERROR: Stage or comp was not defined");
            System.out.println("ERROR: Stage or comp was not defined");
            exitStatusVal = 1;
        }
        if (exitStatusVal != 0) {
            VerificationLogData.traceLogData();
        }
        Trace.out((String)"==== cluvfy exiting normally.");
        System.exit(exitStatusVal);
    }
}

